﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System.Data;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for TopCustomerOrdTotalReport.xaml
    /// </summary>
    public partial class TopCustomerOrdTotalReport : Page
    {
        public TopCustomerOrdTotalReport()
        {
            InitializeComponent();
            txtStartDate.SelectedDate = txtEndDate.SelectedDate = DateTime.Now;
            LoadReport(DateTime.Now, DateTime.Now);
        }

        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvTopCustomersByOrderCost, "CustomerCostReport");
        }

        private void LoadReport(DateTime startDate, DateTime endDate)
        {
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
          {
              DataTable dtTopCustomers = ReportsBL.GetCustomersByOrderTotal(startDate, endDate);
              gvTopCustomersByOrderCost.Dispatcher.BeginInvoke((Action)(() => gvTopCustomersByOrderCost.ItemsSource = dtTopCustomers.DefaultView));
          });
        }
        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            if (txtStartDate.SelectedDate != null && txtEndDate.SelectedDate != null)
            {
                LoadReport(txtStartDate.SelectedDate.Value, txtEndDate.SelectedDate.Value);
            }
            else
            {
                MessageBox.Show("Please select both the start date and end date", "Error!", MessageBoxButton.OK, MessageBoxImage.Error);
            }
        }
    }
}
